USE [SCRIBEINTERNAL]
GO

/****** Object:  Table [dbo].[ACT_DATA]    Script Date: 03/25/2016 11:16:54 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

IF OBJECT_ID(N'dbo.ACT_DATA', N'U') IS NOT NULL
BEGIN
   PRINT 'Table Exists'
   DROP TABLE dbo.ACT_DATA
END
GO

CREATE TABLE [dbo].[ACT_DATA](
	[ACT ID] [varchar](15) NULL,
	[ACT CREATED] [varchar](25) NULL,
	[ACT LST UPD] [varchar](25) NULL,
	[ACT CREATED BY] [varchar](15) NULL,
	[ACT LST UPD BY] [varchar](15) NULL,
	[ACT CRT LOGIN] [varchar](50) NULL,
	[ACT SR ID] [varchar](15) NULL,
	[ACT SR] [varchar](64) NULL,
	[ACT COMMENTS] [varchar](1000) NULL,
	[ACT TYPE] [varchar](30) NULL,
	[ACT STATUS] [varchar](30) NULL,
	[ACT DESC] [varchar](250) NULL,
	[ACT OBO] [varchar](1) NULL,
	[ACT OBO NAME] [varchar](100) NULL,
	[ACT FAC] [varchar](15) NULL,
	[ACT END] [varchar](25) NULL,
	[ACT REASON] [varchar](100) NULL,
	[ACT COPAY REQ] [numeric](18, 0) NULL,
	[ACT NO COPAY] [numeric](18, 0) NULL,
	[ACT NO CHANGES] [numeric](18, 0) NULL,
	[ACT EMAIL CMT] [varchar](1500) NULL,
	[ACT REF DESC] [varchar](255) NULL,
	[ACT DOS] [varchar](20) NULL,
	[ACT FP BILL] [varchar](30) NULL,
	[ACT TP BILL] [varchar](30) NULL,
	[ACT CV STATUS] [varchar](1) NULL,
	[ACT RX NUM] [varchar](30) NULL,
	[ACT FILL DATE] [varchar](20) NULL,
	[ACT INS CO] [varchar](100) NULL,
	[ACT INS REP NAME] [varchar](100) NULL,
	[ACT INS PHN NUM] [varchar](40) NULL,
	[ACT DOD] [varchar](20) NULL,
	[ACT CONT LN] [varchar](15) NULL,
	[ACT CONT FN] [varchar](15) NULL,
	[recordid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[sequenceid] [bigint] IDENTITY(1,1) NOT NULL,
	[datecreated] [datetime] NULL,
	[errormessage] [varchar](250) NULL,
	[importstatus] [varchar](15) NULL,
 CONSTRAINT [PK_ACT_DATA] PRIMARY KEY CLUSTERED 
(
	[recordid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[ACT_DATA] ADD  CONSTRAINT [DF_ACT_DATA_recordid]  DEFAULT (newid()) FOR [recordid]
GO

ALTER TABLE [dbo].[ACT_DATA] ADD  CONSTRAINT [DF_ACT_DATA_datecreated]  DEFAULT (getdate()) FOR [datecreated]
GO


--======================================================================================================


USE [SCRIBEINTERNAL]
GO

/****** Object:  Table [dbo].[CN_DATA]    Script Date: 03/25/2016 11:17:34 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

IF OBJECT_ID(N'dbo.CN_DATA', N'U') IS NOT NULL
BEGIN
   PRINT 'Table Exists'
   DROP TABLE dbo.CN_DATA
END
GO

CREATE TABLE [dbo].[CN_DATA](
	[CN ID] [varchar](15) NULL,
	[CN CREATED] [varchar](25) NULL,
	[CN LST UPD] [varchar](25) NULL,
	[CN CREATED BY] [varchar](15) NULL,
	[CN LST UPD BY] [varchar](15) NULL,
	[CN SR ID] [varchar](15) NULL,
	[CN TYPE] [varchar](220) NULL,
	[CN NOTE] [text] NULL,
	[CN STATUS] [varchar](255) NULL,
	[CN SR INFO] [varchar](50) NULL,
	[recordid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[sequenceid] [bigint] IDENTITY(1,1) NOT NULL,
	[datecreated] [datetime] NULL,
	[errormessage] [varchar](250) NULL,
	[importstatus] [varchar](15) NULL,
 CONSTRAINT [PK_CN_DATA] PRIMARY KEY CLUSTERED 
(
	[recordid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[CN_DATA] ADD  CONSTRAINT [DF_CN_DATA_recordid]  DEFAULT (newid()) FOR [recordid]
GO

ALTER TABLE [dbo].[CN_DATA] ADD  CONSTRAINT [DF_CN_DATA_datecreated]  DEFAULT (getdate()) FOR [datecreated]
GO


------------------------------------------------------------------------------------------------------


USE [SCRIBEINTERNAL]
GO

/****** Object:  Table [dbo].[EMP_DATA]    Script Date: 03/25/2016 11:18:10 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

IF OBJECT_ID(N'dbo.EMP_DATA', N'U') IS NOT NULL
BEGIN
   PRINT 'Table Exists'
   DROP TABLE dbo.EMP_DATA
END
GO

CREATE TABLE [dbo].[EMP_DATA](
	[EMP_ID] [varchar](15) NULL,
	[EMP_CREATED] [varchar](25) NULL,
	[EMP_LAST_UPD] [varchar](25) NULL,
	[EMP_CREATED_BY] [varchar](15) NULL,
	[EMP_LAST_UPD_BY] [varchar](15) NULL,
	[EMP_LN] [varchar](50) NULL,
	[EMP_FN] [varchar](50) NULL,
	[EMP_MN] [varchar](50) NULL,
	[EMP_LOGIN] [varchar](50) NULL,
	[EMP_PHN] [varchar](40) NULL,
	[EMP_EMAIL] [varchar](350) NULL,
	[EMP_JOB_TITLE] [varchar](75) NULL,
	[EMP_POS] [varchar](15) NULL,
	[EMP_DIV] [varchar](15) NULL,
	[EMP_RESP] [varchar](50) NULL,
	[EMP_ORG] [varchar](15) NULL,
	[recordid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[sequenceid] [bigint] IDENTITY(1,1) NOT NULL,
	[datecreated] [datetime] NULL,
	[errormessage] [varchar](250) NULL,
	[importstatus] [varchar](15) NULL,
 CONSTRAINT [PK_EMP_DATA] PRIMARY KEY CLUSTERED 
(
	[recordid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[EMP_DATA] ADD  CONSTRAINT [DF_EMP_DATA_recordid]  DEFAULT (newid()) FOR [recordid]
GO

ALTER TABLE [dbo].[EMP_DATA] ADD  CONSTRAINT [DF_EMP_DATA_datecreated]  DEFAULT (getdate()) FOR [datecreated]
GO


--=============================================================================================================


USE [SCRIBEINTERNAL]
GO

/****** Object:  Table [dbo].[FAC_DATA]    Script Date: 03/25/2016 11:18:36 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

IF OBJECT_ID(N'dbo.FAC_DATA', N'U') IS NOT NULL
BEGIN
   PRINT 'Table Exists'
   DROP TABLE dbo.FAC_DATA
END
GO

CREATE TABLE [dbo].[FAC_DATA](
	[FAC_ID] [varchar](15) NULL,
	[FAC_CREATED] [varchar](25) NULL,
	[FAC_LST_UPD] [varchar](25) NULL,
	[FAC_CREATED_BY] [varchar](15) NULL,
	[FAC_LST_UPD_BY] [varchar](15) NULL,
	[FAC_NAME] [varchar](100) NULL,
	[FAC_CPAC] [varchar](50) NULL,
	[FAC_REGION] [varchar](50) NULL,
	[FAC_VISN] [varchar](30) NULL,
	[FAC_ST_NUM] [varchar](30) NULL,
	[FAC_SITE] [varchar](50) NULL,
	[FAC_ADDR] [varchar](200) NULL,
	[FAC_ADDR2] [varchar](200) NULL,
	[FAC_CITY] [varchar](50) NULL,
	[FAC_STATE] [varchar](100) NULL,
	[FAC_ZIP] [varchar](30) NULL,
	[FAC_COUNTRY] [varchar](30) NULL,
	[FAC_PHN] [varchar](40) NULL,
	[FAC_FAX] [varchar](40) NULL,
	[FAC_EMAIL] [varchar](350) NULL,
	[recordid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[sequenceid] [bigint] IDENTITY(1,1) NOT NULL,
	[datecreated] [datetime] NULL,
	[errormessage] [varchar](250) NULL,
	[importstatus] [varchar](15) NULL,
 CONSTRAINT [PK_FAC_DATA] PRIMARY KEY CLUSTERED 
(
	[recordid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[FAC_DATA] ADD  CONSTRAINT [DF_FAC_DATA_recordid]  DEFAULT (newid()) FOR [recordid]
GO

ALTER TABLE [dbo].[FAC_DATA] ADD  CONSTRAINT [DF_FAC_DATA_datecreated]  DEFAULT (getdate()) FOR [datecreated]
GO


--====================================================================================================================


USE [SCRIBEINTERNAL]
GO

/****** Object:  Table [dbo].[FACDET_DATA]    Script Date: 03/25/2016 11:19:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

IF OBJECT_ID(N'dbo.FACDET_DATA', N'U') IS NOT NULL
BEGIN
   PRINT 'Table Exists'
   DROP TABLE dbo.FACDET_DATA
END
GO

CREATE TABLE [dbo].[FACDET_DATA](
	[FAC_ID] [varchar](15) NULL,
	[FAC_CREATED] [varchar](25) NULL,
	[FAC_LST_UPD] [varchar](25) NULL,
	[FAC_CREATED_BY] [varchar](15) NULL,
	[FAC_LST_UPD_BY] [varchar](15) NULL,
	[FAC_CON_TYPE] [varchar](100) NULL,
	[FAC_DEPT_PHN] [varchar](50) NULL,
	[FAC_DEPT_EXT] [varchar](100) NULL,
	[FAC_HOURS] [varchar](50) NULL,
	[FAC_NAME] [varchar](100) NULL,
	[FAC_DEPT_CMT] [varchar](2500) NULL,
	[FAC_DEPT_FAX] [varchar](30) NULL,
	[FAC_DEPT_PHN2] [varchar](30) NULL,
	[recordid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[sequenceid] [bigint] IDENTITY(1,1) NOT NULL,
	[datecreated] [datetime] NULL,
	[errormessage] [varchar](250) NULL,
	[importstatus] [varchar](15) NULL,
 CONSTRAINT [PK_FACDET_DATA] PRIMARY KEY CLUSTERED 
(
	[recordid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[FACDET_DATA] ADD  CONSTRAINT [DF_FACDET_DATA_recordid]  DEFAULT (newid()) FOR [recordid]
GO

ALTER TABLE [dbo].[FACDET_DATA] ADD  CONSTRAINT [DF_FACDET_DATA_datecreated]  DEFAULT (getdate()) FOR [datecreated]
GO

--====================================================================================================================


USE [SCRIBEINTERNAL]
GO

/****** Object:  Table [dbo].[FACLOC_DATA]    Script Date: 03/25/2016 11:19:31 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

IF OBJECT_ID(N'dbo.FACLOC_DATA', N'U') IS NOT NULL
BEGIN
   PRINT 'Table Exists'
   DROP TABLE dbo.FACLOC_DATA
END
GO

CREATE TABLE [dbo].[FACLOC_DATA](
	[FAC ID] [varchar](15) NULL,
	[FAC CREATED] [varchar](25) NULL,
	[FAC LST UPD] [varchar](25) NULL,
	[FAC CREATED BY] [varchar](15) NULL,
	[FAC LST UPD BY] [varchar](15) NULL,
	[FAC NAME] [varchar](100) NULL,
	[FAC ADDR] [varchar](200) NULL,
	[FAC ADDR2] [varchar](200) NULL,
	[CITY] [varchar](50) NULL,
	[STATE] [varchar](50) NULL,
	[ZIPCODE] [varchar](30) NULL,
	[COUNTRY] [varchar](30) NULL,
	[ORG INT ID] [varchar](15) NULL,
	[recordid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[sequenceid] [bigint] IDENTITY(1,1) NOT NULL,
	[datecreated] [datetime] NULL,
	[errormessage] [varchar](250) NULL,
	[importstatus] [varchar](15) NULL,
 CONSTRAINT [PK_FACLOC_DATA] PRIMARY KEY CLUSTERED 
(
	[recordid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[FACLOC_DATA] ADD  CONSTRAINT [DF_FACLOC_DATA_recordid]  DEFAULT (newid()) FOR [recordid]
GO

ALTER TABLE [dbo].[FACLOC_DATA] ADD  CONSTRAINT [DF_FACLOC_DATA_datecreated]  DEFAULT (getdate()) FOR [datecreated]
GO


--==============================================================================================================


USE [SCRIBEINTERNAL]
GO

/****** Object:  Table [dbo].[SRREQ_DATA]    Script Date: 03/25/2016 11:19:55 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

IF OBJECT_ID(N'dbo.SRREQ_DATA', N'U') IS NOT NULL
BEGIN
   PRINT 'Table Exists'
   DROP TABLE dbo.SRREQ_DATA
END
GO

CREATE TABLE [dbo].[SRREQ_DATA](
	[ROW ID] [varchar](15) NULL,
	[SR NUM] [varchar](64) NULL,
	[SR CREATED] [varchar](25) NULL,
	[SR LAST UPD] [varchar](25) NULL,
	[SR CREATED BY] [varchar](15) NULL,
	[SR LST UPD BY] [varchar](15) NULL,
	[SR DATE ASSIGN] [varchar](25) NULL,
	[SR OWNER ID] [varchar](15) NULL,
	[SR OWNER NAME] [varchar](15) NULL,
	[SR FIRST CLOSED] [varchar](25) NULL,
	[SR CLOSED DATE] [varchar](25) NULL,
	[SR TYPE] [varchar](50) NULL,
	[SR AREA] [varchar](30) NULL,
	[SR SUB AREA] [varchar](30) NULL,
	[SR STATUS] [varchar](30) NULL,
	[SR SUB STATUS] [varchar](30) NULL,
	[SR SUBTYPE] [varchar](30) NULL,
	[SR RESOLUTION] [varchar](30) NULL,
	[SR SUMMARY] [varchar](2000) NULL,
	[SR PRIORITY] [varchar](30) NULL,
	[VET LN] [varchar](15) NULL,
	[VET FN] [varchar](15) NULL,
	[VET SSN] [varchar](15) NULL,
	[VET EDIPI] [varchar](15) NULL,
	[VET DOB] [varchar](15) NULL,
	[VET PHN] [varchar](15) NULL,
	[VET CALLBACK] [varchar](50) NULL,
	[VET SEX] [varchar](15) NULL,
	[VET EMAIL] [varchar](15) NULL,
	[VET ENROLL DT] [varchar](15) NULL,
	[VET ADDR1] [varchar](15) NULL,
	[VET ADDR2] [varchar](15) NULL,
	[VET CITY] [varchar](15) NULL,
	[VET STATE] [varchar](15) NULL,
	[VET ZIP] [varchar](15) NULL,
	[VET FLAG NOTE] [varchar](15) NULL,
	[SR FAC ORG TYPE] [varchar](15) NULL,
	[SR FAC NAME] [varchar](15) NULL,
	[SR FAC VISN] [varchar](15) NULL,
	[SR FAC STATION] [varchar](15) NULL,
	[SR FAC ADDR] [varchar](15) NULL,
	[SR FAC CITY] [varchar](15) NULL,
	[SR FAC STATE] [varchar](15) NULL,
	[SR FAC ZIP] [varchar](15) NULL,
	[SR FAC PHN] [varchar](15) NULL,
	[SR REWORK FLAG] [varchar](1) NULL,
	[SR CALLBACK FLAG] [varchar](1) NULL,
	[DIS EVAC] [varchar](1) NULL,
	[DIS EMP HLTH] [varchar](50) NULL,
	[DIS EMP FAM HLTH] [varchar](50) NULL,
	[DIS HOME DEST] [varchar](30) NULL,
	[SR MOD NUM] [decimal](28, 0) NULL,
	[recordid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[sequenceid] [bigint] IDENTITY(1,1) NOT NULL,
	[datecreated] [datetime] NULL,
	[errormessage] [varchar](250) NULL,
	[importstatus] [varchar](15) NULL,
 CONSTRAINT [PK_SRREQ_DATA] PRIMARY KEY CLUSTERED 
(
	[recordid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[SRREQ_DATA] ADD  CONSTRAINT [DF_SRREQ_DATA_recordid]  DEFAULT (newid()) FOR [recordid]
GO

ALTER TABLE [dbo].[SRREQ_DATA] ADD  CONSTRAINT [DF_SRREQ_DATA_datecreated]  DEFAULT (getdate()) FOR [datecreated]
GO


--=======================================================================================================================


USE [SCRIBEINTERNAL]
GO

/****** Object:  Table [dbo].[VET_DATA]    Script Date: 03/25/2016 11:20:23 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

IF OBJECT_ID(N'dbo.VET_DATA', N'U') IS NOT NULL
BEGIN
   PRINT 'Table Exists'
   DROP TABLE dbo.VET_DATA
END
GO

CREATE TABLE [dbo].[VET_DATA](
	[VET_ID] [varchar](15) NULL,
	[VET_CREATED] [varchar](25) NULL,
	[VET_LST_UPD] [varchar](25) NULL,
	[VET_CREATED_BY] [varchar](15) NULL,
	[VET_LST_UPD_BY] [varchar](15) NULL,
	[VET_TITLE] [varchar](15) NULL,
	[VET_LN] [varchar](50) NULL,
	[VET_FN] [varchar](50) NULL,
	[VET_MN] [varchar](50) NULL,
	[VET_SUF] [varchar](15) NULL,
	[VET_SSN] [varchar](20) NULL,
	[VET_EDIPI] [varchar](50) NULL,
	[VET_SEX] [varchar](30) NULL,
	[VET_PHN_NUM] [varchar](40) NULL,
	[VET_ALT_PHN_NUM] [varchar](15) NULL,
	[VET_ADDR1] [varchar](15) NULL,
	[VET_ADDR2] [varchar](15) NULL,
	[VET_CITY] [varchar](15) NULL,
	[VET_STATE] [varchar](15) NULL,
	[VET_ZIP] [varchar](15) NULL,
	[VET_COUNTRY] [varchar](15) NULL,
	[VET_EMAIL] [varchar](350) NULL,
	[VET_ENROLL_DT] [varchar](25) NULL,
	[VET_FLAG_NOTE] [varchar](250) NULL,
	[VET_DOB] [varchar](25) NULL,
	[recordid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[sequenceid] [bigint] IDENTITY(1,1) NOT NULL,
	[datecreated] [datetime] NULL,
	[errormessage] [varchar](250) NULL,
	[importstatus] [varchar](15) NULL,
 CONSTRAINT [PK_VET_DATA] PRIMARY KEY CLUSTERED 
(
	[recordid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[VET_DATA] ADD  CONSTRAINT [DF_VET_DATA_recordid]  DEFAULT (newid()) FOR [recordid]
GO


--==================================================================================================================

USE [SCRIBEINTERNAL]
GO

/****** Object:  Table [dbo].[VETADDR_DATA]    Script Date: 03/25/2016 11:20:44 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

IF OBJECT_ID(N'dbo.VETADDR_DATA', N'U') IS NOT NULL
BEGIN
   PRINT 'Table Exists'
   DROP TABLE dbo.VETADDR_DATA
END
GO

CREATE TABLE [dbo].[VETADDR_DATA](
	[VET_ADDR_ID] [varchar](15) NULL,
	[VET_CREATED] [varchar](25) NULL,
	[VET_LST_UPD] [varchar](25) NULL,
	[VET_CREATED_BY] [varchar](15) NULL,
	[VET_LST_UPD_BY] [varchar](15) NULL,
	[VET_ID] [varchar](15) NULL,
	[VET_ADDR1] [varchar](200) NULL,
	[VET_ADDR2] [varchar](100) NULL,
	[VET_CITY] [varchar](50) NULL,
	[VET_STATE] [varchar](10) NULL,
	[VET_ZIP] [varchar](30) NULL,
	[VET_COUNTRY] [varchar](30) NULL,
	[VET_MAIL_TO] [varchar](1) NULL,
	[recordid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[sequenceid] [bigint] IDENTITY(1,1) NOT NULL,
	[datecreated] [datetime] NULL,
	[errormessage] [varchar](250) NULL,
	[importstatus] [varchar](15) NULL,
 CONSTRAINT [PK_VETADDR_DATA] PRIMARY KEY CLUSTERED 
(
	[recordid] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[VETADDR_DATA] ADD  CONSTRAINT [DF_VETADDR_DATA_recordid]  DEFAULT (newid()) FOR [recordid]
GO

ALTER TABLE [dbo].[VETADDR_DATA] ADD  CONSTRAINT [DF_VETADDR_DATA_datecreated]  DEFAULT (getdate()) FOR [datecreated]
GO





